package gov.va.med.mhv.journal.web.util;

import java.util.HashMap;
import java.util.Map;


public class ActivityTypeDetailMap {
	
	private static final Map<String, String> measure;
	private static final Map<String, String> intensity;
	private static final Map<String, String> timeOfDay;
	
    public static final String INTENSITY_LOW = "Low impact";
    public static final String INTENSITY_MODERATE = "Moderate impact";
    public static final String INTENSITY_HIGH = "High impact";
    
    public static final String TIME_OF_THE_DAY_MORNING = "Morning";
    public static final String TIME_OF_THE_DAY_AFTERNOON = "Afternoon";
    public static final String TIME_OF_THE_DAY_EVE = "Evening";
    public static final String TIME_OF_THE_DAY_NIGHT = "Night";
    
    public static final String MEASURE_MIN = "Min(s)";
    public static final String MEASURE_HR = "hr(s)";
    public static final String MEASURE_MILE = "mile(s)";
    public static final String MEASURE_KM = "kilopmeter(s)";
    public static final String MEASURE_LAP = "lap(s)";
    public static final String MEASURE_POUND = "pound(s)";
    public static final String MEASURE_KG = "kilogram(s)";
    
	
    static {	
		measure = new HashMap<String, String>(7);
		measure.put("1", MEASURE_MIN);
		measure.put("2", MEASURE_HR);
		measure.put("3", MEASURE_MILE);
		measure.put("4", MEASURE_KM);
        measure.put("5", MEASURE_LAP);
        measure.put("6", MEASURE_POUND);
        measure.put("7", MEASURE_KG);
        
        intensity = new HashMap<String, String>(4);
        intensity.put("1", TIME_OF_THE_DAY_MORNING);
        intensity.put("2", TIME_OF_THE_DAY_AFTERNOON);
        intensity.put("3", TIME_OF_THE_DAY_EVE);
        intensity.put("4", TIME_OF_THE_DAY_NIGHT);
        
        timeOfDay = new HashMap<String, String>(3);
        timeOfDay.put("1", INTENSITY_LOW);
        timeOfDay.put("2", INTENSITY_MODERATE);
        timeOfDay.put("3", INTENSITY_HIGH);
	}


	public static Map<String, String> getMeasure() {
		return measure;
	}


	public static Map<String, String> getIntensity() {
		return intensity;
	}


	public static Map<String, String> getTimeofday() {
		return timeOfDay;
	}
	
	
	
}
